/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.ModifiableInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalOrderIterator<V, E>
extends CrossComponentIterator<V, E, Object> {
    private LinkedList<V> queue;
    private Map<V, ModifiableInteger> inDegreeMap;

    public TopologicalOrderIterator(DirectedGraph<V, E> directedGraph) {
        this(directedGraph, new LinkedList(), new HashMap());
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, LinkedList<V> linkedList, Map<V, ModifiableInteger> map) {
        this(directedGraph, TopologicalOrderIterator.initialize(directedGraph, linkedList, map));
        this.queue = linkedList;
        this.inDegreeMap = map;
    }

    private TopologicalOrderIterator(DirectedGraph<V, E> directedGraph, V v) {
        super(directedGraph, v);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        return this.queue.isEmpty();
    }

    @Override
    protected void encounterVertex(V v, E e) {
        this.putSeenData(v, null);
        this.decrementInDegree(v);
    }

    @Override
    protected void encounterVertexAgain(V v, E e) {
        this.decrementInDegree(v);
    }

    @Override
    protected V provideNextVertex() {
        return this.queue.removeFirst();
    }

    private void decrementInDegree(V v) {
        ModifiableInteger modifiableInteger = this.inDegreeMap.get(v);
        if (modifiableInteger.value > 0) {
            --modifiableInteger.value;
            if (modifiableInteger.value == 0) {
                this.queue.addLast(v);
            }
        }
    }

    private static <V, E> V initialize(DirectedGraph<V, E> directedGraph, LinkedList<V> linkedList, Map<V, ModifiableInteger> map) {
        for (Object v : directedGraph.vertexSet()) {
            int n = directedGraph.inDegreeOf(v);
            map.put((ModifiableInteger)v, new ModifiableInteger(n));
            if (n != 0) continue;
            linkedList.add(v);
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.getFirst();
    }
}

