/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.AbstractGraph;
import org.jgrapht.util.ArrayUnenforcedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Subgraph<V, E>
extends AbstractGraph<V, E>
implements Serializable {
    private static final long serialVersionUID = 3208313055169665387L;
    private static final String NO_SUCH_EDGE_IN_BASE = "no such edge in base graph";
    private static final String NO_SUCH_VERTEX_IN_BASE = "no such vertex in base graph";
    Set<E> edgeSet = new LinkedHashSet();
    Set<V> vertexSet = new LinkedHashSet<V>();
    private transient Set<E> unmodifiableEdgeSet = null;
    private transient Set<V> unmodifiableVertexSet = null;
    private Graph<V, E> base;
    private boolean isInduced = false;

    public Subgraph(Graph<V, E> graph, Set<V> set, Set<E> set2) {
        this.base = graph;
        if (graph instanceof ListenableGraph) {
            ((ListenableGraph)graph).addGraphListener(new BaseGraphListener());
        }
        this.addVerticesUsingFilter(graph.vertexSet(), set);
        this.addEdgesUsingFilter(graph.edgeSet(), set2);
    }

    public Subgraph(Graph<V, E> graph, Set<V> set) {
        this(graph, set, null);
        this.isInduced = true;
    }

    @Override
    public Set<E> getAllEdges(V v, V v2) {
        ArrayUnenforcedSet<E> arrayUnenforcedSet = null;
        if (this.containsVertex(v) && this.containsVertex(v2)) {
            arrayUnenforcedSet = new ArrayUnenforcedSet<E>();
            Set<E> set = this.base.getAllEdges(v, v2);
            for (E e : set) {
                if (!this.edgeSet.contains(e)) continue;
                arrayUnenforcedSet.add(e);
            }
        }
        return arrayUnenforcedSet;
    }

    @Override
    public E getEdge(V v, V v2) {
        Set<E> set = this.getAllEdges(v, v2);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.iterator().next();
    }

    @Override
    public EdgeFactory<V, E> getEdgeFactory() {
        return this.base.getEdgeFactory();
    }

    @Override
    public E addEdge(V v, V v2) {
        this.assertVertexExist(v);
        this.assertVertexExist(v2);
        if (!this.base.containsEdge(v, v2)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        Set<E> set = this.base.getAllEdges(v, v2);
        for (E e : set) {
            if (this.containsEdge(e)) continue;
            this.edgeSet.add(e);
            return e;
        }
        return null;
    }

    @Override
    public boolean addEdge(V v, V v2, E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsEdge(e)) {
            throw new IllegalArgumentException(NO_SUCH_EDGE_IN_BASE);
        }
        this.assertVertexExist(v);
        this.assertVertexExist(v2);
        assert (this.base.getEdgeSource(e) == v);
        assert (this.base.getEdgeTarget(e) == v2);
        if (this.containsEdge(e)) {
            return false;
        }
        this.edgeSet.add(e);
        return true;
    }

    @Override
    public boolean addVertex(V v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (!this.base.containsVertex(v)) {
            throw new IllegalArgumentException(NO_SUCH_VERTEX_IN_BASE);
        }
        if (this.containsVertex(v)) {
            return false;
        }
        this.vertexSet.add(v);
        return true;
    }

    @Override
    public boolean containsEdge(E e) {
        return this.edgeSet.contains(e);
    }

    @Override
    public boolean containsVertex(V v) {
        return this.vertexSet.contains(v);
    }

    public int degreeOf(V v) {
        this.assertVertexExist(v);
        ((UndirectedGraph)this.base).degreeOf(v);
        int n = 0;
        for (E e : this.base.edgesOf(v)) {
            if (!this.containsEdge(e)) continue;
            ++n;
            if (!this.getEdgeSource(e).equals(this.getEdgeTarget(e))) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Set<E> edgeSet() {
        if (this.unmodifiableEdgeSet == null) {
            this.unmodifiableEdgeSet = Collections.unmodifiableSet(this.edgeSet);
        }
        return this.unmodifiableEdgeSet;
    }

    @Override
    public Set<E> edgesOf(V v) {
        this.assertVertexExist(v);
        ArrayUnenforcedSet<E> arrayUnenforcedSet = new ArrayUnenforcedSet<E>();
        Set<E> set = this.base.edgesOf(v);
        for (E e : set) {
            if (!this.containsEdge(e)) continue;
            arrayUnenforcedSet.add(e);
        }
        return arrayUnenforcedSet;
    }

    public int inDegreeOf(V v) {
        this.assertVertexExist(v);
        int n = 0;
        for (Object e : ((DirectedGraph)this.base).incomingEdgesOf(v)) {
            if (!this.containsEdge(e)) continue;
            ++n;
        }
        return n;
    }

    public Set<E> incomingEdgesOf(V v) {
        this.assertVertexExist(v);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet();
        Set set = ((DirectedGraph)this.base).incomingEdgesOf(v);
        for (Object e : set) {
            if (!this.containsEdge(e)) continue;
            arrayUnenforcedSet.add(e);
        }
        return arrayUnenforcedSet;
    }

    public int outDegreeOf(V v) {
        this.assertVertexExist(v);
        int n = 0;
        for (Object e : ((DirectedGraph)this.base).outgoingEdgesOf(v)) {
            if (!this.containsEdge(e)) continue;
            ++n;
        }
        return n;
    }

    public Set<E> outgoingEdgesOf(V v) {
        this.assertVertexExist(v);
        ArrayUnenforcedSet arrayUnenforcedSet = new ArrayUnenforcedSet();
        Set set = ((DirectedGraph)this.base).outgoingEdgesOf(v);
        for (Object e : set) {
            if (!this.containsEdge(e)) continue;
            arrayUnenforcedSet.add(e);
        }
        return arrayUnenforcedSet;
    }

    @Override
    public boolean removeEdge(E e) {
        return this.edgeSet.remove(e);
    }

    @Override
    public E removeEdge(V v, V v2) {
        E e = this.getEdge(v, v2);
        return (E)(this.edgeSet.remove(e) ? e : null);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v) && this.base.containsVertex(v)) {
            this.removeAllEdges(this.edgesOf(v));
        }
        return this.vertexSet.remove(v);
    }

    @Override
    public Set<V> vertexSet() {
        if (this.unmodifiableVertexSet == null) {
            this.unmodifiableVertexSet = Collections.unmodifiableSet(this.vertexSet);
        }
        return this.unmodifiableVertexSet;
    }

    @Override
    public V getEdgeSource(E e) {
        return this.base.getEdgeSource(e);
    }

    @Override
    public V getEdgeTarget(E e) {
        return this.base.getEdgeTarget(e);
    }

    private void addEdgesUsingFilter(Set<E> set, Set<E> set2) {
        for (E e : set) {
            boolean bl;
            V v = this.base.getEdgeSource(e);
            V v2 = this.base.getEdgeTarget(e);
            boolean bl2 = this.containsVertex(v) && this.containsVertex(v2);
            boolean bl3 = bl = set2 == null || set2.contains(e);
            if (!bl2 || !bl) continue;
            this.addEdge(v, v2, e);
        }
    }

    private void addVerticesUsingFilter(Set<V> set, Set<V> set2) {
        for (V v : set) {
            if (set2 != null && !set2.contains(v)) continue;
            this.addVertex(v);
        }
    }

    protected Graph<V, E> getBase() {
        return this.base;
    }

    @Override
    public double getEdgeWeight(E e) {
        return this.base.getEdgeWeight(e);
    }

    public void setEdgeWeight(E e, double d) {
        ((WeightedGraph)this.base).setEdgeWeight(e, d);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BaseGraphListener
    implements GraphListener<V, E>,
    Serializable {
        private static final long serialVersionUID = 4343535244243546391L;

        private BaseGraphListener() {
        }

        @Override
        public void edgeAdded(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            if (Subgraph.this.isInduced) {
                Object e = graphEdgeChangeEvent.getEdge();
                Subgraph.this.addEdge(Subgraph.this.base.getEdgeSource(e), Subgraph.this.base.getEdgeTarget(e), e);
            }
        }

        @Override
        public void edgeRemoved(GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent) {
            Object e = graphEdgeChangeEvent.getEdge();
            Subgraph.this.removeEdge(e);
        }

        @Override
        public void vertexAdded(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
        }

        @Override
        public void vertexRemoved(GraphVertexChangeEvent<V> graphVertexChangeEvent) {
            Object v = graphVertexChangeEvent.getVertex();
            Subgraph.this.removeVertex(v);
        }
    }
}

