/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class VertexView
extends AbstractCellView {
    public static transient VertexRenderer renderer;
    public static final Rectangle2D defaultBounds;
    protected Rectangle2D bounds;
    public static transient int[] defaultCursors;
    public static transient int[] xCursors;
    public static transient int[] yCursors;

    public VertexView() {
    }

    public VertexView(Object object) {
        super(object);
    }

    public void update() {
        super.update();
        this.bounds = GraphConstants.getBounds(this.allAttributes);
        if (this.bounds == null) {
            this.bounds = this.allAttributes.createRect(defaultBounds);
            GraphConstants.setBounds(this.allAttributes, this.bounds);
        }
        this.groupBounds = null;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D rectangle2D) {
        this.bounds = rectangle2D;
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public CellHandle getHandle(GraphContext graphContext) {
        if (GraphConstants.isSizeable(this.getAllAttributes()) && !GraphConstants.isAutoSize(this.getAllAttributes()) && graphContext.getGraph().isSizeable()) {
            return new SizeHandle(this, graphContext);
        }
        return null;
    }

    public Rectangle2D getBounds() {
        Rectangle2D rectangle2D = super.getBounds();
        if (rectangle2D == null) {
            rectangle2D = this.bounds;
        }
        return rectangle2D;
    }

    public Point2D getCenterPoint() {
        return AbstractCellView.getCenterPoint(this);
    }

    public Point2D getPerimeterPoint(Point2D point2D, Point2D point2D2) {
        return AbstractCellView.getCenterPoint(this);
    }

    public Point2D getPerimeterPoint(EdgeView edgeView, Point2D point2D, Point2D point2D2) {
        if (this.getRenderer() instanceof VertexRenderer) {
            return ((VertexRenderer)this.getRenderer()).getPerimeterPoint(this, point2D, point2D2);
        }
        return super.getPerimeterPoint(edgeView, point2D, point2D2);
    }

    static {
        try {
            renderer = new VertexRenderer();
        }
        catch (Error error) {
            // empty catch block
        }
        defaultBounds = new Rectangle2D.Double(10.0, 10.0, 20.0, 20.0);
        defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
        xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
        yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};
    }

    public static class SizeHandle
    implements CellHandle,
    Serializable {
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient JGraph graph;
        protected transient VertexView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient GraphContext context;
        protected transient Rectangle2D initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle2D[] r = new Rectangle2D[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = null;
        protected boolean editing = false;

        public SizeHandle(VertexView vertexView, GraphContext graphContext) {
            this.graph = graphContext.getGraph();
            this.vertex = vertexView;
            this.editing = this.graph.getEditingCell() == this.vertex.getCell();
            int n = GraphConstants.getSizeableAxis(this.vertex.getAllAttributes());
            this.cursors = n == 1 ? xCursors : (n == 2 ? yCursors : defaultCursors);
            this.portViews = graphContext.createTemporaryPortViews();
            this.initialBounds = (Rectangle2D)this.vertex.getBounds().clone();
            this.context = graphContext;
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle2D.Double();
            }
            this.invalidate();
        }

        public boolean isConstrainedSizeEvent(MouseEvent mouseEvent) {
            GraphUI graphUI = this.graph.getUI();
            if (graphUI instanceof BasicGraphUI) {
                return ((BasicGraphUI)graphUI).isConstrainedMoveEvent(mouseEvent);
            }
            return false;
        }

        public void paint(Graphics graphics) {
            this.invalidate();
            graphics.setColor(this.editing ? this.graph.getLockedHandleColor() : this.graph.getHandleColor());
            for (int i = 0; i < this.r.length; ++i) {
                if (this.cursors[i] == 0) continue;
                graphics.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
            }
            if (!this.graph.isXorEnabled()) {
                this.firstOverlayInvocation = false;
                this.overlay(graphics);
            }
        }

        protected void initOffscreen() {
            if (!this.graph.isXorEnabled()) {
                return;
            }
            try {
                Graphics graphics = this.graph.getOffgraphics();
                graphics.setColor(this.graph.getBackground());
                graphics.setPaintMode();
                Rectangle rectangle = this.graph.getBounds();
                graphics.fillRect(0, 0, rectangle.width, rectangle.height);
                this.graph.getUI().paint(graphics, this.graph);
            }
            catch (Exception exception) {
                this.offgraphics = null;
            }
            catch (Error error) {
                this.offgraphics = null;
            }
        }

        public void overlay(Graphics graphics) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    graphics.setColor(Color.black);
                    Rectangle2D rectangle2D = this.graph.toScreen((Rectangle2D)this.cachedBounds.clone());
                    graphics.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth() - 2, (int)rectangle2D.getHeight() - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.scale(this.graph.getScale(), this.graph.getScale());
                    this.graph.getUI().paintCell(graphics, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        for (int i = 0; i < this.contextViews.length; ++i) {
                            this.graph.getUI().paintCell(graphics, this.contextViews[i], this.contextViews[i].getBounds(), true);
                        }
                    }
                    if (!this.graph.isPortsScaled()) {
                        graphics2D.setTransform(affineTransform);
                    }
                    if (this.portViews != null && this.graph.isPortsVisible()) {
                        this.graph.getUI().paintPorts(graphics, this.portViews);
                    }
                    graphics2D.setTransform(affineTransform);
                }
            }
            this.firstOverlayInvocation = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.vertex != null) {
                for (int i = 0; i < this.r.length; ++i) {
                    if (!this.r[i].contains(mouseEvent.getPoint())) continue;
                    this.graph.setCursor(new Cursor(this.cursors[i]));
                    mouseEvent.consume();
                    return;
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.graph.isSizeable()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(mouseEvent.getPoint()) || this.cursors[i] == 0) continue;
                HashSet<Object> hashSet = new HashSet<Object>();
                hashSet.add(this.vertex.getCell());
                this.contextViews = this.context.createTemporaryContextViews(hashSet);
                CellView[] cellViewArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                if (cellViewArray.length >= BasicGraphUI.MAXHANDLES) {
                    this.cachedBounds = (Rectangle2D)this.initialBounds.clone();
                }
                mouseEvent.consume();
                this.index = i;
                return;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            Object object;
            Rectangle2D rectangle2D;
            Graphics graphics;
            if (this.firstDrag && this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            Rectangle2D rectangle2D2 = null;
            Graphics graphics2 = graphics = this.offgraphics != null ? this.offgraphics : this.graph.getGraphics();
            if (this.index == -1) {
                return;
            }
            if (this.offgraphics != null || !this.graph.isXorEnabled()) {
                rectangle2D2 = this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone());
                rectangle2D = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (rectangle2D != null) {
                    rectangle2D2.add(rectangle2D);
                }
            }
            rectangle2D = this.computeBounds(mouseEvent);
            if (this.graph.isXorEnabled()) {
                graphics.setColor(this.graph.getForeground());
                graphics.setXORMode(this.graph.getBackground().darker());
                this.overlay(graphics);
            } else {
                this.firstOverlayInvocation = false;
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = rectangle2D;
            } else {
                object = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                for (n = 0; n < ((CellView[])object).length; ++n) {
                    CellView cellView = this.graph.getGraphLayoutCache().getMapping(object[n].getCell(), false);
                    if (cellView == null) continue;
                    AttributeMap attributeMap = (AttributeMap)cellView.getAllAttributes().clone();
                    object[n].changeAttributes(attributeMap);
                    object[n].refresh(this.graph.getModel(), this.context, false);
                }
                this.vertex.setBounds(rectangle2D);
                if (this.vertex != null) {
                    this.graph.getGraphLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.graph.getGraphLayoutCache().update(this.contextViews);
                }
            }
            if (this.graph.isXorEnabled()) {
                this.overlay(graphics);
            }
            if (this.offgraphics != null || !this.graph.isXorEnabled()) {
                rectangle2D2.add(this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone()));
                object = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (object != null) {
                    rectangle2D2.add((Rectangle2D)object);
                }
                n = PortView.SIZE + 10;
                if (this.graph.isPortsScaled()) {
                    n = (int)(this.graph.getScale() * (double)n);
                }
                int n2 = n / 2;
                rectangle2D2.setFrame(rectangle2D2.getX() - (double)n2, rectangle2D2.getY() - (double)n2, rectangle2D2.getWidth() + (double)n, rectangle2D2.getHeight() + (double)n);
                double d = Math.max(0.0, rectangle2D2.getX());
                double d2 = Math.max(0.0, rectangle2D2.getY());
                double d3 = d + rectangle2D2.getWidth();
                double d4 = d2 + rectangle2D2.getHeight();
                if (this.offgraphics != null) {
                    this.graph.drawImage((int)d, (int)d2, (int)d3, (int)d4, (int)d, (int)d2, (int)d3, (int)d4);
                } else {
                    this.graph.repaint((int)rectangle2D2.getX(), (int)rectangle2D2.getY(), (int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight());
                }
            }
        }

        protected Rectangle2D computeBounds(MouseEvent mouseEvent) {
            double d = this.initialBounds.getX();
            double d2 = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double d3 = this.initialBounds.getY();
            double d4 = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D point2D = this.graph.fromScreen(this.graph.snap((Point2D)mouseEvent.getPoint().clone()));
            point2D.setLocation(Math.max(0.0, point2D.getX()), Math.max(0.0, point2D.getY()));
            if (this.index > 4) {
                d4 = point2D.getY();
            } else if (this.index < 3) {
                d3 = point2D.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                d = point2D.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                d2 = point2D.getX();
            }
            double d5 = d2 - d;
            double d6 = d4 - d3;
            if (this.isConstrainedSizeEvent(mouseEvent) || GraphConstants.isConstrained(this.vertex.getAllAttributes())) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    d6 = d5;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    d5 = d6;
                } else {
                    d6 = d5;
                    d3 = d4 - d6;
                }
            }
            if (d5 < 0.0) {
                d += d5;
                d5 = Math.abs(d5);
            }
            if (d6 < 0.0) {
                d3 += d6;
                d6 = Math.abs(d6);
            }
            return new Rectangle2D.Double(d, d3, d5 + 1.0, d6 + 1.0);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(mouseEvent);
                this.vertex.setBounds(this.cachedBounds);
                Object[] objectArray = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map map = GraphConstants.createAttributes(objectArray, null);
                this.graph.getGraphLayoutCache().edit(map, null, null, null);
            }
            mouseEvent.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
        }

        protected void invalidate() {
            Rectangle2D rectangle2D = this.graph.getCellBounds(this.vertex.getCell());
            if (rectangle2D != null) {
                rectangle2D = (Rectangle2D)rectangle2D.clone();
                this.graph.toScreen(rectangle2D);
                int n = this.graph.getHandleSize();
                int n2 = 2 * n;
                double d = rectangle2D.getX() - (double)n;
                double d2 = rectangle2D.getY() - (double)n;
                double d3 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - (double)n;
                double d4 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - (double)n;
                double d5 = rectangle2D.getX() + rectangle2D.getWidth() - (double)n;
                double d6 = rectangle2D.getY() + rectangle2D.getHeight() - (double)n;
                this.r[0].setFrame(d, d2, n2, n2);
                this.r[1].setFrame(d3, d2, n2, n2);
                this.r[2].setFrame(d5, d2, n2, n2);
                this.r[3].setFrame(d, d4, n2, n2);
                this.r[4].setFrame(d5, d4, n2, n2);
                this.r[5].setFrame(d, d6, n2, n2);
                this.r[6].setFrame(d3, d6, n2, n2);
                this.r[7].setFrame(d5, d6, n2, n2);
            }
        }
    }
}

